using System;
using System.Threading;
using System.Collections.Generic;
using System.Text;

namespace Localization
{
    class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine(ApplicationText.Welcome);

            Thread.CurrentThread.CurrentUICulture =
              new System.Globalization.CultureInfo("fr-CA");
            Console.WriteLine(ApplicationText.Welcome);

            // wywietla wyraenie "weekend" w jzyku francuskim (kanadyjskim)
            Console.WriteLine(ApplicationText.weekend);

            // wywietla wyraenie "weekend" w jzyku francuskim (neutralym)
            // poniewa w aplikacji nie ma zlokalizowanego zasobu dla fr-BE
            // zostao to sprowadzone do jzyka neutralnego francuskiego
            Thread.CurrentThread.CurrentUICulture =
              new System.Globalization.CultureInfo("fr-BE");
            Console.WriteLine(ApplicationText.weekend);

            // wywietla wyraenie "weekend" w jzyku neutralnym (domylnym)
            // poniewa nie ma zlokalizowanych zasobw dla hi-IN
            Thread.CurrentThread.CurrentUICulture =
              new System.Globalization.CultureInfo("hi-IN");
            Console.WriteLine(ApplicationText.weekend);

            Console.ReadLine();
        }
    }
}
